<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كوبون</title>
    <style>
        .body-copon {
            max-width: 500px;
            margin: auto;
            direction: rtl;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgb(0 0 0 / 15%);
            font-size: 16px;
            line-height: 24px;
            font-family: 'Cairo', sans-serif;
            color: #555;
            text-align: right;
            border: 1px solid #666666;
        }

        .top {
            display: flex;
            flex-wrap: nowrap;
            align-content: center;
            justify-content: space-between;
            flex-direction: column;
            margin-right: 20px;
            margin-left: 20px;
            margin-bottom: 15px;
            border-bottom: 1px solid #666666;
            padding: 20px;
            padding-left: 40px;
            padding-right: 40px;
            text-align: center;
        }
        .divRow2,
        .headRow {
            display: flex;
            justify-content: space-around;
            background-color: #fff;
            border: 1px solid #666666;
            border-spacing: 5px;
        }

        .divRow2 {
            background-color: #fff;
            border: 1px solid #666666;
            border-spacing: 5px;
        }

        .divCell2 {
            padding: 10px;
            width: 33%;
            text-align: center;
        }
        @media print {
            .body-copon {
                max-width: unset;
                box-shadow: none;
            }
        }

        @page {
            width:80px;
            height:80px;
        }
    </style>
</head>

<body style="display: flex;flex-wrap: wrap;gap: 10px;">

    <?php if(isset($coupon)): ?>
    <div class="body-copon">
        <div class="top">
            <div class="logo">
                <img width="200" src="<?php echo e(asset('/images/logo-full1.png')); ?>" alt="">
            </div>
            <div class="text" style="
            padding-top: 20px;
            font-weight: bold;
            font-size: 20px;">
                <span>كوبون</span>
                <span>(صرف)</span>
        </div>
        <p>مصروفه من : <strong><?php echo e($account->deleteTypeAccount($coupon->clint->name)); ?></strong></p>
        </div>


        <div class="divTable2">
            <div class="headRow">
                <div class="divCell2">رقم القسمية</div>
                <div class="divCell2">النوع</div>
                <div class="divCell2">الكمية</div>
            </div>
            <div class="divRow2">
                <div class="divCell2"><?php if(isset($coupon->id)): ?><?php echo e($coupon->id); ?><?php endif; ?></div>
                <div class="divCell2">
                <?php if(isset($coupon->type)): ?>
                    <?php if($coupon->type==0): ?>
                        بترول
                    <?php else: ?>
                        ديزل   
                    <?php endif; ?>
                <?php endif; ?>
                </div>
                <div class="divCell2"><?php if(isset($coupon->quantity)): ?><?php echo e($coupon->quantity); ?><?php endif; ?> <Span>لتر</Span></div>
            </div>
        </div>
        <strong>ملاحظة : </strong>
        ينتهي هذا الكوبون بتاريخ <?php echo e(explode(' ',$endDate)[0]); ?>

    </div>
    <?php endif; ?>

    <?php if(isset($coupons)): ?>
        <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(isset($coupon)): ?>
            <div class="body-copon">
                <div class="top">
                    <div class="logo">
                        <img width="200" src="<?php echo e(asset('/images/logo-full1.png')); ?>" alt="">
                    </div>
                    <div class="text" style="
                    padding-top: 20px;
                    font-weight: bold;
                    font-size: 20px;">
                        <span>كوبون</span>
                        <span>(صرف)</span>
                    </div>
                    <p>مصروفه من : <strong><?php if(isset($account)): ?><?php echo e($account->deleteTypeAccount($coupon->clint->name)); ?> <?php endif; ?></strong></p>

                </div>


                <div class="divTable2">
                    <div class="headRow">
                        <div class="divCell2">رقم القسمية</div>
                        <div class="divCell2">النوع</div>
                        <div class="divCell2">الكمية</div>
                    </div>
                    <div class="divRow2">
                        <div class="divCell2"><?php if(isset($coupon->id)): ?><?php echo e($coupon->id); ?><?php endif; ?></div>
                        <div class="divCell2">
                        <?php if(isset($coupon->type)): ?>
                            <?php if($coupon->type==0): ?>
                                بترول
                            <?php else: ?>
                                ديزل   
                            <?php endif; ?>
                        <?php endif; ?>
                        </div>
                        <div class="divCell2"><?php if(isset($coupon->quantity)): ?><?php echo e($coupon->quantity); ?><?php endif; ?> <Span>لتر</Span></div>
                    
                    </div>
                </div>
                <strong>ملاحظة : </strong>
                ينتهي هذا الكوبون بتاريخ <?php echo e(explode(' ',$endDate)[0]); ?>

            </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    
</body>
<script>
    window.print();
</script>

</html>
<?php /**PATH C:\Users\Nasser\Desktop\petrol_store\resources\views/copon.blade.php ENDPATH**/ ?>